# SauOS_OSSDISK - 阿里云OSS网盘 Windows 应用

这是一个将阿里云OSS存储空间映射为本地磁盘的Windows应用程序。

## 功能特性

- 连接阿里云OSS存储空间
- 将OSS存储映射为本地磁盘驱动器
- 支持文件的上传、下载和同步
- 类似本地磁盘的操作体验
- 日志记录功能便于问题排查
- 配置管理支持默认设置
- 支持挂载OSS指定目录到本地目录
- 支持开机自动挂载选项
- 支持配置自动保存和加载
- 支持图形化OSS目录选择器

## 系统要求

- Windows 7 或更高版本
- .NET 10.0 SDK 或 Visual Studio 2022
- 阿里云账号及OSS服务访问权限

## 开发环境设置

### 方法一：使用Visual Studio 2022

1. 安装 Visual Studio 2022 (Community版免费)
2. 安装 .NET桌面开发工作负载
3. 打开 `OSSDisk.sln` 解决方案文件
4. 恢复NuGet包（会自动安装阿里云OSS SDK）
5. 编译并运行项目

### 方法二：使用命令行

1. 安装 [.NET 10.0 SDK](https://dotnet.microsoft.com/download/dotnet/10.0)
2. 打开命令提示符或PowerShell
3. 导航到项目目录
4. 运行以下命令：

```bash
# 恢复依赖项
dotnet restore

# 编译项目
dotnet build

# 运行应用
dotnet run
```

或者直接运行主项目：
```bash
dotnet run --project OSSDisk.csproj
```

## 使用方法

1. 启动应用程序
2. 输入阿里云OSS的访问凭证：
   - Endpoint：OSS服务地址（如：oss-cn-hangzhou.aliyuncs.com）
   - AccessKey ID：阿里云访问密钥ID
   - AccessKey Secret：阿里云访问密钥Secret
   - Bucket名称：要挂载的OSS存储空间名称
3. 点击"测试连接"验证配置
4. 设置挂载路径（如：Z:或C:\oss-mount）
5. （可选）设置OSS目录前缀以挂载特定目录：
   - 点击"选择目录"按钮使用图形化目录选择器
   - 或手动输入OSS目录前缀
6. （可选）启用开机自动挂载选项
7. 点击"挂载"将OSS存储映射为本地磁盘

## 新增功能说明

### OSS目录挂载

应用程序现在支持将OSS存储空间中的特定目录挂载到本地目录，而不是挂载整个Bucket。这允许用户只访问他们感兴趣的OSS目录。

使用方法：
1. 在"OSS目录"字段中输入要挂载的OSS目录前缀
2. 例如：`documents/` 或 `images/photos/`
3. 留空表示挂载整个Bucket
4. 或点击"选择目录"按钮使用图形化目录选择器

### 开机自动挂载

应用程序支持开机自动挂载功能，用户可以选择在系统启动时自动挂载OSS存储。

使用方法：
1. 勾选"开机自动挂载"选项
2. 配置好OSS连接参数和挂载设置
3. 点击"挂载"按钮
4. 应用程序会自动保存配置并在下次系统启动时自动挂载

### 图形化OSS目录选择器

应用程序现在支持通过图形化界面浏览和选择OSS目录结构。

使用方法：
1. 连接到OSS存储空间
2. 点击"选择目录"按钮
3. 在弹出的目录选择器中浏览OSS目录结构
4. 双击目录进入子目录
5. 双击文件选择文件
6. 点击"选择"按钮选择当前目录
7. 点击"取消"按钮取消选择

## 项目结构

```
├── OSSDisk.sln             # Visual Studio 解决方案文件
├── OSSDisk.csproj          # 项目文件
├── Program.cs              # 程序入口
├── MainForm.cs             # 主窗体逻辑
├── MainForm.Designer.cs    # 主窗体设计器
├── MainForm.Events.cs      # 主窗体事件处理
├── OSSFileSystem.cs        # OSS文件系统操作类
├── OSSDriveMapper.cs       # OSS驱动映射器
├── OSSDirectorySelector.cs # OSS目录选择器
├── ConfigManager.cs        # 配置管理器
├── Logger.cs               # 日志记录器
├── appsettings.json        # 应用配置文件
└── README.md               # 说明文档
```

### 核心组件

1. **OSSFileSystem**：封装了阿里云OSS的基本操作，包括文件上传、下载、删除等
2. **OSSDriveMapper**：实现OSS与本地文件系统的映射逻辑
3. **MainForm**：提供用户界面用于配置和控制OSS挂载
4. **OSSDirectorySelector**：提供图形化OSS目录选择界面
5. **ConfigManager**：管理应用程序配置，包括自动挂载设置

### 依赖项

- Aliyun.OSS.SDK.NetCore：阿里云OSS SDK
- System.IO.FileSystem.AccessControl：文件系统访问控制

## 注意事项

1. 挂载前请确保指定的挂载路径未被占用
2. 应用程序会在挂载时同步OSS中的文件到本地
3. 卸载时会将本地修改同步回OSS
4. 请妥善保管您的阿里云访问凭证
5. 开机自动挂载功能需要管理员权限才能注册到Windows启动项

## 故障排除

### 无法找到dotnet命令

确保已安装.NET 10.0 SDK，并且已将dotnet添加到系统PATH环境变量中。

### 阿里云访问凭证错误

请检查AccessKey ID和AccessKey Secret是否正确，并确保该账号有访问指定OSS Bucket的权限。

### 挂载路径被占用

请尝试使用其他驱动器号或文件夹路径作为挂载点。

### 开机自动挂载不工作

1. 检查是否以管理员权限运行应用程序
2. 查看Windows注册表项`HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Run`中是否有SauOS_OSSDISK项
3. 确保防病毒软件没有阻止注册表修改

### OSS目录选择器无法显示目录

1. 检查网络连接是否正常
2. 确认OSS访问凭证是否正确
3. 确认Bucket名称是否正确