# 阿里云OSS网盘使用说明

## 应用概述

阿里云OSS网盘是一个Windows应用程序，它可以将阿里云对象存储服务(OSS)映射为本地磁盘驱动器，让用户可以像操作本地文件一样操作OSS中的文件。

## 获取阿里云访问凭证

在使用本应用之前，您需要获取阿里云的访问凭证：

1. 登录阿里云控制台
2. 进入"访问控制" -> "用户" -> "用户管理"
3. 创建新用户或选择现有用户
4. 为用户创建AccessKey（请妥善保管AccessKey Secret）
5. 为用户授权OSS相关权限（如：AliyunOSSFullAccess）

## 应用配置说明

### OSS配置参数

1. **Endpoint**：OSS服务地址
   - 华东1（杭州）：oss-cn-hangzhou.aliyuncs.com
   - 华东2（上海）：oss-cn-shanghai.aliyuncs.com
   - 华北1（青岛）：oss-cn-qingdao.aliyuncs.com
   - 华北2（北京）：oss-cn-beijing.aliyuncs.com
   - 华北3（张家口）：oss-cn-zhangjiakou.aliyuncs.com
   - 华北5（呼和浩特）：oss-cn-huhehaote.aliyuncs.com
   - 华南1（深圳）：oss-cn-shenzhen.aliyuncs.com
   - 西南1（成都）：oss-cn-chengdu.aliyuncs.com
   - 中国（香港）：oss-cn-hongkong.aliyuncs.com
   - 美国西部1（硅谷）：oss-us-west-1.aliyuncs.com
   - 美国东部1（弗吉尼亚）：oss-us-east-1.aliyuncs.com
   - 亚太东南1（新加坡）：oss-ap-southeast-1.aliyuncs.com
   - 亚太东南2（悉尼）：oss-ap-southeast-2.aliyuncs.com
   - 亚太东北1（日本）：oss-ap-northeast-1.aliyuncs.com
   - 欧洲中部1（法兰克福）：oss-eu-central-1.aliyuncs.com
   - 英国（伦敦）：oss-eu-west-1.aliyuncs.com
   - 中东东部1（迪拜）：oss-me-east-1.aliyuncs.com

2. **AccessKey ID**：阿里云访问密钥ID

3. **AccessKey Secret**：阿里云访问密钥Secret

4. **Bucket名称**：要挂载的OSS存储空间名称

### 挂载配置

1. **挂载路径**：本地磁盘驱动器号或文件夹路径
   - 驱动器号示例：Z:、X:、Y:
   - 文件夹路径示例：C:\oss-mount、D:\my-oss

## 使用步骤

### 1. 启动应用

双击运行OSSDisk.exe应用程序。

### 2. 配置OSS连接

在应用程序界面中填写以下信息：
- Endpoint：选择或输入您的OSS服务地址
- AccessKey ID：输入您的阿里云AccessKey ID
- AccessKey Secret：输入您的阿里云AccessKey Secret
- Bucket名称：输入要挂载的OSS存储空间名称

### 3. 测试连接

点击"测试连接"按钮验证配置是否正确。如果连接成功，"挂载"按钮将被激活。

### 4. 设置挂载路径

在"挂载路径"文本框中输入您希望映射的本地路径（如Z:）。

### 5. 挂载OSS

点击"挂载"按钮将OSS存储空间映射为本地磁盘。

### 6. 使用OSS磁盘

挂载成功后，您可以在"我的电脑"或文件资源管理器中看到新映射的磁盘驱动器。您可以像操作本地文件一样进行以下操作：
- 浏览文件和文件夹
- 复制文件到OSS磁盘
- 从OSS磁盘复制文件到本地
- 删除OSS磁盘中的文件
- 创建新文件夹

### 7. 卸载OSS

使用完毕后，点击"卸载"按钮断开OSS连接。应用程序会自动将本地修改同步回OSS。

## 注意事项

### 安全注意事项

1. 请妥善保管您的阿里云访问凭证，不要泄露给他人
2. 建议为本应用创建专门的RAM用户，并只授予必要的OSS权限
3. 定期更换AccessKey以提高安全性

### 性能注意事项

1. OSS是对象存储，不是文件系统，因此性能与本地磁盘有差异
2. 大文件操作可能需要较长时间，请耐心等待
3. 频繁的小文件操作可能影响性能

### 使用限制

1. 不支持文件锁定和并发访问控制
2. 不支持符号链接和硬链接
3. 文件名长度和字符限制遵循OSS规范
4. 单个文件最大支持48.82TB（通过分片上传）

## 故障排除

### 常见问题

#### 1. 连接失败
- 检查Endpoint是否正确
- 检查AccessKey ID和AccessKey Secret是否正确
- 检查网络连接是否正常
- 检查RAM用户是否有访问指定Bucket的权限

#### 2. 挂载失败
- 检查挂载路径是否已被占用
- 检查是否有足够的磁盘空间缓存OSS文件
- 检查应用程序是否有足够的权限

#### 3. 文件操作失败
- 检查文件名是否符合OSS命名规范
- 检查文件大小是否超过OSS限制
- 检查网络连接是否稳定

### 查看日志

应用程序会在同目录下生成ossdisk.log日志文件，记录操作详情。如遇到问题，可以查看日志文件以获取更多信息。

## 技术说明

### 架构设计

本应用采用以下技术架构：
1. 使用阿里云OSS .NET SDK与OSS服务通信
2. 实现了一个虚拟文件系统层，将OSS对象映射为文件和文件夹
3. 提供了本地缓存机制以提高访问性能
4. 实现了文件变更同步机制

### 文件同步机制

1. 挂载时：从OSS下载所有文件到本地缓存
2. 操作时：直接操作本地缓存文件
3. 卸载时：将本地修改同步回OSS

### 性能优化

1. 使用增量同步，只上传修改过的文件
2. 本地缓存减少重复下载
3. 异步操作提高响应速度

## 版本信息

当前版本：1.0.0

## 技术支持

如遇到技术问题，请联系开发者或查看阿里云官方文档。